<?php

namespace Velis\Session;

use stdClass;

class DummySession implements SessionInterface
{
    private stdClass $data;

    public function __construct()
    {
        $this->data = new stdClass();
    }

    /**
     * {@inheritDoc}
     */
    public function close(): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function destroy(string $id): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function gc(int $max_lifetime): int|false
    {
        return 0;
    }

    /**
     * {@inheritDoc}
     */
    public function open(string $path, string $name): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function read(string $id): string|false
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function write(string $id, string $data): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function start(): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function exists(): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function setId(string $id): void
    {
    }

    /**
     * {@inheritDoc}
     */
    public function getId(): string
    {
        return '';
    }

    /**
     * {@inheritDoc}
     */
    public function regenerateId(bool $deleteOldSession = true): SessionInterface
    {
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function has(string $key): bool
    {
        return property_exists($this->data, $key);
    }

    /**
     * {@inheritDoc}
     */
    public function set(string $key, mixed $value): void
    {
        $this->data->{$key} = $value;
    }

    /**
     * {@inheritDoc}
     */
    public function get(string $key)
    {
        if (property_exists($this->data, $key)) {
            return $this->data->{$key};
        }

        return null;
    }

    /**
     * {@inheritDoc}
     */
    public function remove(string $key): void
    {
    }

    /**
     * {@inheritDoc}
     */
    public function checkSession(string $sessionId, $userIds = null): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function getPrefix(): ?string
    {
        return null;
    }
}
