<?php

namespace Velis\Redis;

use Redis;
use Resque_Failure;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class RedisClient implements RedisClientInterface
{
    private Redis $wrapped;

    /**
     * @param Redis $wrapped
     */
    public function __construct(Redis $wrapped)
    {
        $this->wrapped = $wrapped;

        Resque_Failure::setBackend(Failure::class);
    }

    /**
     * {@inheritDoc}
     */
    public function connect(string $host, int $port = 6379): bool
    {
        return $this->wrapped->connect($host, $port);
    }

    /**
     * {@inheritDoc}
     */
    public function publish(string $channel, string $message): int
    {
        return $this->wrapped->publish($channel, $message);
    }
}
