<?php

namespace Velis\Queue;

use Psr\Log\LogLevel;
use Resque_Log;
use Resque_Worker;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class Worker implements WorkerInterface
{
    /**
     * @var Resque_Worker
     */
    private $wrapped;

    /**
     * Worker constructor
     * @param Resque_Worker $worker
     */
    public function __construct(Resque_Worker $worker)
    {
        $this->wrapped = $worker;
    }

    /**
     * {@inheritDoc}
     */
    public function work($interval)
    {
        $logger = new Resque_Log(true);

        $this->wrapped->setLogger($logger);
        $this->wrapped->pruneDeadWorkers();
        $logger->log(LogLevel::NOTICE, 'Starting worker {worker}', ['worker' => $this->wrapped]);

        $this->wrapped->work($interval);
    }
}
