<?php

namespace Velis;

class PrivsLogger
{
    private $logs = [];

    /**
     * @param string $module
     * @param ?string $priv
     * @param ?string $file
     * @return void
     */
    public function log($module, $priv = null, $file = null)
    {
        $log = "$module /  $priv";
        $logs = $this->all();

        if ($file === null) {
            $file = 'all';
        }

        $logs[$file][] = $log;
        $logs[$file] = array_unique($logs[$file]);

        $this->logs = $logs;
    }

    public function all()
    {
        return $this->logs;
    }
}
