<?php

namespace Velis;

use Model\DataObject;
use Velis\Notification\Recipient;

/**
 * Abstract person model
 * @author Olek Procki <olo@velis.pl>
 */
interface PersonInterface
{

    /**
     * Returns first name
     * @return string
     */
    public function getName();


    /**
     * Returns last name
     * @return string
     */
    public function getLastName();


    /**
     * Returns short user name
     *
     * @param bool $reversed
     * @return string
     */
    public function getShortName($reversed = false);


    /**
     * Returns user first & last name
     * @return string
     */
    public function getFullName($reversed = false);
}
