<?php

namespace Velis\Pdf\Renderer;

use Velis\App;

class WkhtmltopdfRenderer extends PdfRenderer
{
    const WKHTMLTOPDF_CMD = 'wkhtmltopdf';

    public function render(): string
    {
        if ($this->content) {
            $this->pdfDoc->setContent($this->content);
        }

        return $this->pdfDoc->render();
    }

    private function getContentAsFile(string $hash = ''): string
    {
        $contentFile = DATA_PATH . 'temp/pdf-content-' . $hash . '.html';
        file_put_contents($contentFile, $this->getContent());

        return $contentFile;
    }
}
