<?php

namespace Velis\Pdf\Renderer;

use Velis\Pdf\Document;
use Velis\Pdf\RenderableInterface;

abstract class PdfRenderer implements RenderableInterface
{
    protected Document $pdfDoc;

    protected string $content;
    protected array $options;

    public function __construct(Document $pdfDoc, array $options = [])
    {
        $this->pdfDoc = $pdfDoc;
        $this->options = $options;
    }

    public function setContent(string $content): void
    {
        $this->content = $content;
    }

    public function getContent(): string
    {
        return $this->content;
    }
}
