<?php

namespace Velis;

use ArrayObject;

/**
 * @author Jan Małysiak <jan.malysiak@velistech.com>
 */
class ParameterBag extends ArrayObject
{
    /**
     * {@inheritDoc}
     */
    public function __construct($array = [], $flags = 0, $iteratorClass = 'ArrayIterator')
    {
        parent::__construct($array ?? [], $flags, $iteratorClass);
    }

    /**
     * {@inheritDoc}
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($key)
    {
        if (!$this->offsetExists($key)) {
            return null;
        }

        return parent::offsetGet($key);
    }
}
