<?php

namespace Velis\Notification;

use Velis\Mvc\View\Engine\EngineInterface;
use Velis\Notification\ContentModifier\StripPolishCharsModifier;

class SmsRenderer
{
    protected string $type;
    protected EngineInterface $renderer;
    protected array $contentModifiers;
    public function __construct(
        string $type,
        EngineInterface $renderer,
        ?array $contentModifiers = []
    ) {
        $this->type = $type;
        $this->renderer = $renderer;
        $this->contentModifiers = $contentModifiers;
    }

    /**
     * Renders notification message
     *
     * @param string $mode
     * @param string $layout
     * @return string
     * @throws SmartyException
     */
    public function renderMessage(string $mode, string $layout = 'default')
    {
        $smarty = clone $this->renderer;
        $smarty->assign("_rendererMode", $mode);

        $modifier = new StripPolishCharsModifier();
        $content = $modifier($smarty->fetch($this->type . '.tpl'));

        foreach ($this->contentModifiers as $modifier) {
            $content = $modifier($content, ['layout' => $layout]);
        }

        return $content;
    }
}
