<?php

namespace Velis\Notification;

use Velis\App;
use Velis\Lang;

class SmsRecipients
{
    protected array $recipients = [];


    public function __construct(array $recipients = [])
    {
        foreach ($recipients as $recipient) {
            $this->add($recipient);
        }
    }

    /**
     * @param $recipient
     * @return void
     */
    public function add($recipient)
    {

        if (is_string($recipient)) {
            $this->recipients[] = $recipient;
        } elseif ($recipient instanceof SmsRecipient && $recipient->getMobile()) {
            $this->recipients[] = $recipient->getMobile();
        } elseif (App::$di->has('flash')) {
            App::$di['flash']->error(
                sprintf(Lang::get('GENERAL_SMS_FAILED_NO_PHONE'), $recipient)
            );
        }
    }

    /**
     * @return array
     */
    public function get(): array
    {
        return array_filter($this->recipients);
    }
}
