<?php

namespace Velis\Notification;

use Velis\Exception as VelisException;
use Velis\Model\BaseModel;

/**
 * Resque notification sender job
 * @author Olek Procki <olo@velis.pl>
 */
class SenderJob extends BaseModel
{
    /**
     * Set up something before perform, like establishing a database connection
     */
    public function setUp()
    {
    }


    /**
     * Sends scheduled notification
     */
    public function perform()
    {
        $queue = new Queue();

        if (!$queue->sendItem($this->args['notification_log_id'])) {
            if ($exception = reset($queue->getErrors())) {
                VelisException::raise(
                    $exception->getMessage(),
                    $exception->getCode(),
                    $exception
                );
            }
        }
    }


    /**
     * Run after perform, like closing resources
     */
    public function tearDown()
    {
    }
}
