<?php

namespace Velis\Mvc\View\Helper;

use Velis\App;

/**
 * NoteCacheClean file helper
 * @author Robert Krzuk <robert.krzuk@velis.pl>
 */
class NoteCacheClean
{
    /**
     * Returns script for clean note cache HTML
     * @return string
     */
    public function __invoke()
    {
        $html = '';

        if (!empty(App::$session->noteCache) && is_array(App::$session->noteCache)) {
            $html .= '<script type="text/javascript">';
            foreach (App::$session->noteCache as $noteCache) {
                $html .= 'localStorage.removeItem("' . $noteCache . '");
                             ';
            }
            $html .= '</script>';
            App::$session->noteCache = array();
        }

        return $html;
    }
}
