<?php

namespace Velis\Mvc\View\Helper;

use Velis\App;
use Velis\Mvc\Router;

class IsModuleSwitched
{
    public function __invoke(string $module): bool
    {
        /** @var Router */
        $router = App::getService('router');

        foreach ($router->getSwitchedModules() as $sourceModuleName => $switchedModuleName) {
            if ($sourceModuleName === $module) {
                return true;
            }
        }

        return false;
    }
}
