<?php

namespace Velis\Mvc\View\Helper;

use Velis\Output;
use Velis\App;

/**
 * Simple breadcrubms helper
 * @author Olek Procki <olo@velis.pl>
 */
class Breadcrumbs
{

    /**
     * Returns breadcrumbs HTML
     * @return string
     */
    public function __invoke()
    {
        $i   = 0;
        $ret = '';

        $pages = App::getService('view')->getBreadcrumbsPages();

        foreach ($pages as $page) {
            $i++;
            if ($page['uri']) {
                $ret .= '<a href="' . $page['uri'] . '">' . Output::cut($page['label'], 30) . '</a>';
            } else {
                $ret .= Output::cut($page['label'], 30);
            }
            if ($i < count($pages)) {
                $ret .= "&nbsp;&nbsp;&frasl;&nbsp;&nbsp;";
            }
        }
        return $ret;
    }
}
