<?php

namespace Velis\Mvc\Validators\Rules;

use Velis\App;
use Velis\Filter\Validation;
use Velis\Mvc\Validators\Rules\RuleInterface;

class StringMax implements RuleInterface
{
    private int $max;
    private bool $included;

    public function __construct($max, $included = false)
    {
        $this->max = $max;
        $this->included = $included;
    }

    public function validate(array $data, $fieldName): bool
    {
        /** @var Validation $validation */
        $validation = App::$di->get('validation');
        $validation->add($fieldName, Validation::TYPE_STRING_MAX, [
            "max"      => $this->max,
            "included" => $this->included
        ]);

        return $validation->validate($data)->count() === 0;
    }

    public function getErrorMessage($fieldName): string
    {
        return "{$fieldName} maximum length is {$this->max}";
    }
}
