<?php

namespace Velis\Mvc\Validators\Rules;

use Velis\App;
use Velis\Filter\Validation;

class Required implements RuleInterface
{
    public function validate(array $data, $fieldName): bool
    {
        /** @var Validation $validation */
        $validation = App::$di->get('validation');
        $validation->add($fieldName, Validation::TYPE_PRESENCE_OF, []);

        return $validation->validate($data)->count() === 0;
    }

    public function getErrorMessage($fieldName): string
    {
        return "{$fieldName} is required";
    }
}
