<?php

namespace Velis\Mvc\UISwitch;

use Velis\App;

final class UISwitch
{
    public function isNewUIEnabled(): bool
    {
        if ($this->canSwitch()) {
            return (bool) App::$user->settings('ReactModulesSwitched');
        }

        return true;
    }

    public function canSwitch(): bool
    {
        return App::settings('EnableUISwitch', 1) || App::$user->hasPriv('User', 'AllowUISwitching');
    }
}
