<?php

namespace Velis\Mvc\Controller\Utils;

use ReflectionClass;
use ReflectionException;
use Velis\Mvc\Controller\Utils\Attributes\PublicAction;
use Velis\Output;

class RouteClassifier
{
    public static function isFileAction(string $actionName): bool
    {
        return str_starts_with($actionName, 'file') && ctype_upper(substr($actionName, 4, 1));
    }

    public static function isPrintAction(string $actionName): bool
    {
        return str_starts_with($actionName, 'print');
    }

    public static function isPublic(string $controllerClass, string $actionName): bool
    {
        $methodName = Output::toCamelCase($actionName) . 'Action';

        try {
            $reflectionClass = new ReflectionClass($controllerClass);
            $reflectionMethod = $reflectionClass->getMethod($methodName);
        } catch (ReflectionException) {
            // We can silently ignore this exception because it means that the method does not exist,
            // which may happen when someone tries to access a non-existent route.
            return false;
        }

        return !empty($reflectionMethod->getAttributes(PublicAction::class));
    }
}
