<?php

namespace Velis\Mvc\Controller\RestRequestHandler;

use Phalcon\Http\RequestInterface;

abstract class AbstractRestRequestHandler implements RestRequestHandlerInterface
{
    protected ?RestRequestHandlerInterface $next = null;

    public function setNext(RestRequestHandlerInterface $handler): RestRequestHandlerInterface
    {
        $this->next = $handler;
        return $this->next;
    }

    protected function handleNext(RequestInterface $request): void
    {
        if ($this->next instanceof RestRequestHandlerInterface) {
            $this->next->handle($request);
        }
    }
}
