<?php

namespace Velis\Mvc\Controller\Listeners;

use Velis\Lang;
use Velis\Mvc\Controller\Listeners\Concrete\AbstractListener;

/**
 * Adds filtered params to session.
 */
class ResolveLangParamListener extends AbstractListener
{
    public function handle(): void
    {
        if (!$this->request->getHeader('lang')) {
            return;
        }

        $lang = $this->request->getHeader('lang');
        Lang::switchLanguage($lang, setCookie: false);
    }
}
