<?php

namespace Velis\Mvc\Controller\Listeners;

use Velis\App;
use Velis\Mvc\Controller\Listeners\Concrete\AbstractListener;
use Velis\RateLimiter\RateLimitRouteWrapperInterface;

/**
 * @author Szymon Janaczek <szymon.janaczek@singu.com>
 */
final class RateLimitMiddleware extends AbstractListener
{
    public function handle(): void
    {
        /** @var RateLimitRouteWrapperInterface $rateLimitMiddleware */
        $rateLimitMiddleware = App::getService(RateLimitRouteWrapperInterface::class);
        $rateLimitMiddleware->checkUri(currentUri: $this->request->getURI());
    }
}
