<?php

namespace Velis\Mvc\Controller\Listeners\Concrete;

use Velis\Mvc\Controller\Listeners\ApiAccessListener;
use Velis\Mvc\Controller\Listeners\CheckApiVersionListener;
use Velis\Mvc\Controller\Listeners\CheckSyncDataListener;
use Velis\Mvc\Controller\Listeners\DestroySessionListener;
use Velis\Mvc\Controller\Listeners\InitProfilerListener;
use Velis\Mvc\Controller\Listeners\PrintableActionListener;
use Velis\Mvc\Controller\Listeners\RateLimitMiddleware;
use Velis\Mvc\Controller\Listeners\ResolveLangParamListener;
use Velis\Mvc\Controller\Listeners\ResolveSessionParamsListener;
use Velis\Mvc\Controller\Listeners\SentryMetadata;
use Velis\Mvc\Controller\Listeners\TemporaryConvertSortParamListener;
use Velis\Mvc\Controller\Listeners\ValidateDtoRequestListener;
use Velis\Mvc\Controller\Listeners\ValidateFormParamsListener;
use Velis\Mvc\Controller\Listeners\VerifyCsrfTokenListener;
use Velis\Mvc\Controller\Listeners\WrapDataListener;

class Listeners
{
    /**
     * Common listeners
     * @var array<string, class-string<AbstractListener>[]|array<class-string<AbstractListener>, array>>
     */
    public static array $commonListeners = [
        'dispatch:beforeExecuteRoute' => [
            SentryMetadata::class,
            RateLimitMiddleware::class,
            ResolveLangParamListener::class,
            ValidateFormParamsListener::class,
            TemporaryConvertSortParamListener::class,
        ],

        'dispatch:afterExecuteRoute' => [
            InitProfilerListener::class,
            PrintableActionListener::class,
            WrapDataListener::class,
        ],
    ];

    /**
     * @var array<string, array<string, class-string<AbstractListener>[]|array<class-string<AbstractListener>, array>>>
     */
    public static array $listenerGroups = [
        'session' => [
            'dispatch:beforeExecuteRoute' => [
                ApiAccessListener::class,
                VerifyCsrfTokenListener::class,
                ValidateDtoRequestListener::class => [
                    'error_format' => ValidateDtoRequestListener::ERROR_FORMAT_ARRAY
                ],
            ],
        ],

        'token' => [
            'dispatch:beforeExecuteRoute' => [
                ValidateDtoRequestListener::class => [
                    'error_format' => ValidateDtoRequestListener::ERROR_FORMAT_ARRAY
                ],
                CheckApiVersionListener::class,
                ResolveSessionParamsListener::class,
            ],

            'dispatch:afterExecuteRoute' => [
                CheckSyncDataListener::class,
                DestroySessionListener::class,
            ],
        ],

        'public' => [
            'dispatch:beforeExecuteRoute' => [
                ValidateDtoRequestListener::class => [
                    'error_format' => ValidateDtoRequestListener::ERROR_FORMAT_ARRAY,
                ],
            ],
        ],
    ];
}
