<?php

namespace Velis\Mvc\Controller\Exception;

use Exception;
use Throwable;
use Velis\Exception as VelisException;
use Velis\Mvc\Dto\Core\ErrorMessageGroup;

abstract class AbstractHttpException extends Exception implements ErrorMessagesInterface
{
    public function __construct(?string $message = '', int $code = 0, ?Throwable $previous = null)
    {
        $callee = get_called_class();
        if (!isset($this->code)) {
            VelisException::raise("The code property has not been declared in $callee");
        }

        if ($code !== 0) {
            VelisException::raise("Changing the HTTP exception status code is disallowed in $callee");
        }

        parent::__construct($message, $code, $previous);
    }

    public function getErrors(): ErrorMessageGroup
    {
        return ErrorMessageGroup::fromArrayOfStrings([$this->getMessage()]);
    }
}
