<?php

namespace Velis\Mvc\Controller\Decorator;

use Velis\Mvc\Controller\Exception\InternalServerError;

abstract class AbstractItemDecorator
{
    const LIST_CONTEXT = 'list';
    const SELECT_CONTEXT = 'select';

    private function handleMethodNotImplemented()
    {
        $callee = get_called_class();
        $func = debug_backtrace()[1]['function'];

        $e = new InternalServerError("$func method not implemented in $callee");
        if ($_SERVER['ON_DEV']) {
            throw $e;
        } else {
            error_log($e);
        }
    }

    public function getItemData(): array
    {
        $this->handleMethodNotImplemented();

        return [];
    }

    public function getListItemData(): array
    {
        $this->handleMethodNotImplemented();

        return [];
    }

    public function getSelectItemData(): array
    {
        $this->handleMethodNotImplemented();

        return [];
    }

    public function getData($context = ''): array
    {
        switch ($context) {
            case self::LIST_CONTEXT:
                return $this->getListItemData();
                break;
            case self::SELECT_CONTEXT:
                return $this->getSelectItemData();
                break;
            default:
                return $this->getItemData();
                break;
        }
    }
}
