<?php

namespace Velis\Model\Relationship;

/**
 * Part of the Helper class getting Models related to the source Model.
 *
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
class Relation
{
    public string $name;
    public string $model;
    public string $type;
    public string $localKey;
    public string $foreignKey;
    public ?array $columns = null;

    /**
     * @throws InvalidRelationshipTypeException
     */
    public function __construct(
        string $name,
        string $type,
        string $model,
        string $localKey,
        string $foreignKey,
        ?array $columns = null
    ) {
        if (!defined(RelationType::class . '::' . $type)) {
            throw new InvalidRelationshipTypeException();
        }

        $this->name = $name;
        $this->model = $model;
        $this->type = $type;
        $this->localKey = $localKey;
        $this->foreignKey = $foreignKey;
        $this->columns = $columns;
    }
}
