<?php

namespace Velis\Model\RelationLoader\Relations;

use Velis\Model\DataObject;

/**
 * One-to-Many database relation logical class.
 *
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 *
 * @template TRelatedModel of DataObject
 * @template TTargetModel of DataObject
 * @extends HasManyOrOne<TRelatedModel, TTargetModel>
 */
class HasManyRelation extends HasManyOrOne
{
    /**
     * {@inheritDoc}
     */
    protected function getRelatedModels(DataObject $targetModel, array $relatedModels): ?array
    {
        // If the Target Model does not have a local key field, return null.
        if (!isset($targetModel[$this->foreignKey])) {
            return null;
        }

        return $relatedModels[$targetModel[$this->foreignKey]];
    }
}
