<?php

namespace Velis\Model\RelationLoader;

use ReflectionException;
use Velis\Model\RelationLoader\Exceptions\UnknownModelException;

class RelationLoaderFactory
{
    /**
     * @template T
     * @param class-string<T> $modelClass
     * @param array<T> $models
     * @return RelationLoader<T>
     * @throws ReflectionException
     * @throws UnknownModelException
     */
    public function createLoader(string $modelClass, array $models): RelationLoader
    {
        return RelationLoader::for($modelClass)
            ->to($models);
    }
}
