<?php

namespace Velis\Model\RelationLoader\Exceptions;

use Velis\Exception;

class NotLoadedRelationException extends Exception
{
    public function __construct(string $relationName, $code = null, $previous = null, $debugInfo = null)
    {
        $message = "Relation `$relationName` is not loaded. Please, load it before accessing it.";

        parent::__construct($message, $code, $previous, $debugInfo);
    }
}
