<?php

namespace Velis\Model\RelationLoader\Exceptions;

use Velis\Exception;

class ForeignKeyNotLoadedException extends Exception
{
    public function __construct($foreignKeyName, $code = null, $previous = null, $debugInfo = null)
    {
        $message = "Foreign key `$foreignKeyName` needed for relation, was not loaded for target models.";
        $message .= " Probably you should add `$foreignKeyName` column to your SELECT statement.";

        parent::__construct($message, $code, $previous, $debugInfo);
    }
}
