<?php

namespace Velis\Model\File;

final class MimeType
{
    // Text MIME types
    public const TEXT_PLAIN = 'text/plain';
    public const TEXT_HTML = 'text/html';
    public const TEXT_CSS = 'text/css';
    public const TEXT_JAVASCRIPT = 'text/javascript';

    // Image MIME types
    public const IMAGE_JPEG = 'image/jpeg';
    public const IMAGE_PNG = 'image/png';
    public const IMAGE_GIF = 'image/gif';
    public const IMAGE_BMP = 'image/bmp';
    public const IMAGE_SVG_XML = 'image/svg+xml';

    // Application MIME types
    public const APPLICATION_JSON = 'application/json';
    public const APPLICATION_XML = 'application/xml';
    public const APPLICATION_PDF = 'application/pdf';
    public const APPLICATION_ZIP = 'application/zip';
    public const APPLICATION_GZIP = 'application/gzip';
    public const APPLICATION_MSWORD = 'application/msword';
    public const APPLICATION_EXCEL = 'application/vnd.ms-excel';
    public const APPLICATION_POWERPOINT = 'application/vnd.ms-powerpoint';
    public const APPLICATION_OPENXML_WORD = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
    public const APPLICATION_OPENXML_EXCEL = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
    public const APPLICATION_OPENXML_POWERPOINT = 'application/vnd.openxmlformats-officedocument.presentationml.presentation';

    // Audio MIME types
    public const AUDIO_MPEG = 'audio/mpeg';
    public const AUDIO_OGG = 'audio/ogg';
    public const AUDIO_WAV = 'audio/wav';

    // Video MIME types
    public const VIDEO_MP4 = 'video/mp4';
    public const VIDEO_MPEG = 'video/mpeg';
    public const VIDEO_OGG = 'video/ogg';
    public const VIDEO_WEBM = 'video/webm';

    // Multipart MIME types
    public const MULTIPART_FORM_DATA = 'multipart/form-data';
}
