<?php

namespace Velis\Model\DataObject;

use Velis\App;

/**
 * Trait for displaying persons' names
 *
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
trait NameTrait
{
    /**
     * @param bool $reversed
     * @return string
     */
    public function getFullName($reversed = false)
    {
        $firstName = isset($this['first_name']) ? $this['first_name'] : $this['name'];

        if (!$reversed) {
            return sprintf('%s %s', $firstName, $this['last_name']);
        }

        switch (App::$user->getLocale()) {
            case 'en_US':
                return sprintf('%s, %s', $this['last_name'], $firstName);
            default:
                return sprintf('%s %s', $this['last_name'], $firstName);
        }
    }
}
