<?php

/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/zf2 for the canonical source repository
 * @copyright Copyright (c) 2005-2013 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Velis\Mail\Protocol;

use Zend\Mail\Protocol\Smtp\Auth\Crammd5;
use Zend\Mail\Protocol\Smtp\Auth\Plain;
use Zend\ServiceManager\Factory\InvokableFactory;

/**
 * Plugin manager implementation for SMTP extensions.
 *
 * Enforces that SMTP extensions retrieved are instances of Smtp. Additionally,
 * it registers a number of default extensions available.
 */
class SmtpPluginManager extends \Zend\Mail\Protocol\SmtpPluginManager
{
    /**
     * Service aliases
     */
    protected $aliases = [
        'crammd5' => Crammd5::class,
        'cramMd5' => Crammd5::class,
        'CramMd5' => Crammd5::class,
        'cramMD5' => Crammd5::class,
        'CramMD5' => Crammd5::class,
        'login'   => Smtp\Auth\Login::class,
        'Login'   => Smtp\Auth\Login::class,
        'plain'   => Plain::class,
        'Plain'   => Plain::class,
        'smtp'    => Smtp::class,
        'Smtp'    => Smtp::class,
        'SMTP'    => Smtp::class,
        'xoauth2' => SmtpOAuth2::class,
        'Xoauth2' => SmtpOAuth2::class,
    ];

    /**
     * Service factories
     *
     * @var array
     */
    protected $factories = [
        Crammd5::class          => InvokableFactory::class,
        Smtp\Auth\Login::class  => InvokableFactory::class,
        Plain::class            => InvokableFactory::class,
        Smtp::class             => InvokableFactory::class,
        SmtpOAuth2::class       => InvokableFactory::class,

        // v2 normalized service names

        'zendmailprotocolsmtpauthcrammd5' => InvokableFactory::class,
        'zendmailprotocolsmtpauthlogin'   => InvokableFactory::class,
        'zendmailprotocolsmtpauthplain'   => InvokableFactory::class,
        'zendmailprotocolsmtp'            => InvokableFactory::class,
    ];
    /**
     * Default set of extensions
     *
     * @var array
     */
    protected $invokableClasses = array(
        'crammd5' => 'Zend\Mail\Protocol\Smtp\Auth\Crammd5',
        'login'   => 'Velis\Mail\Protocol\Smtp\Auth\Login',
        'plain'   => 'Zend\Mail\Protocol\Smtp\Auth\Plain',
        'smtp'    => 'Velis\Mail\Protocol\Smtp',
    );
}
