<?php

namespace Velis\Log\Sentry;

use Sentry\State\Scope;
use Velis\App\User;

use function Sentry\configureScope;

/**
 * Configure Sentry scope.
 * @author Szymon Janaczek <szymon.janaczek@singu.com>
 */
final class ScopeConfiguration
{

    public function setUser(User $user): ScopeConfiguration
    {
        configureScope(function (Scope $scope) use ($user): void {
            $scope->setUser([
                'id' => $user?->id(),
            ]);
        });

        return $this;
    }

    public function setTag(string $name, mixed $value): ScopeConfiguration
    {
        configureScope(function (Scope $scope) use ($name, $value): void {
            $scope->setTag($name, $value);
        });

        return $this;
    }
}
