<?php

namespace Velis\Lang\LangVariant;

use Velis\Arrays;

class OverloadedLangProvider
{
    /**
     * @var array<string, string>|null
     */
    private ?array $buffered = null;

    /**
     * @param array<string, string> $overloadedLangs
     */
    public function __construct(
        private readonly LangVariantProvider $langVariantProvider,
        private readonly array $overloadedLangs,
    ) {
    }

    /**
     * @return array<string, string>
     */
    public function getOverloadedLangs(): array
    {
        if (null === $this->buffered) {
            $langVariant = $this->langVariantProvider->getLangVariant();
            $overloadedLangs = $langVariant->getOverloadedLangsMap();

            if (!empty($this->overloadedLangs)) {
                $overloadedLangs = Arrays::merge($overloadedLangs, $this->overloadedLangs);
            }

            $this->buffered = $overloadedLangs;
        }

        return $this->buffered;
    }
}
