<?php

namespace Velis\Lang\LangVariant;

/**
 * @author Damian Kurek <damian.kurek@velistech.com>
 */
class OverloadedLang
{
    protected const DIVIDER = '_';

    protected string $langGroup;
    protected string $langKey;
    protected string $overloadedLangKey;

    public function __construct(string $group, string $key, string $overloadedKey)
    {
        $this->langGroup = $group;
        $this->langKey = $key;
        $this->overloadedLangKey = $overloadedKey;
    }

    /**
     * @return string
     */
    public function getKey(): string
    {
        return $this->langGroup . static::DIVIDER . $this->langKey;
    }

    /**
     * @return string
     */
    public function getOverloadedKey(): string
    {
        return $this->langGroup . static::DIVIDER . $this->overloadedLangKey;
    }
}
