<?php

namespace Velis\Http;

use GuzzleHttp\ClientInterface as GuzzleClientInterface;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Http\Message\ResponseInterface;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class Client implements ClientInterface
{
    private GuzzleClientInterface $wrapped;

    public function __construct(GuzzleClientInterface $client)
    {
        $this->wrapped = $client;
    }

    /**
     * {@inheritDoc}
     * @throws GuzzleException
     */
    public function request(string $method, string $uri = '', array $options = []): ResponseInterface
    {
        return $this->wrapped->request($method, $uri, $options);
    }

    /**
     * {@inheritDoc}
     * @throws GuzzleException
     */
    public function get(string $uri = '', array $options = []): ResponseInterface
    {
        return $this->wrapped->request('get', $uri, $options);
    }

    /**
     * {@inheritDoc}
     * @throws GuzzleException
     */
    public function post(string $uri = '', array $options = []): ResponseInterface
    {
        return $this->wrapped->request('post', $uri, $options);
    }

    public function postAsync(string $uri, array $options = []): PromiseInterface
    {
        return $this->wrapped->postAsync($uri, $options);
    }

    /**
     * {@inheritDoc}
     * @throws GuzzleException
     */
    public function put(string $uri = '', array $options = []): ResponseInterface
    {
        return $this->wrapped->request('put', $uri, $options);
    }
}
