<?php


namespace PHP_CodeSniffer\Standards\SinguStandard\Sniffs\Js;

use PHP_CodeSniffer\Sniffs\Sniff;
use PHP_CodeSniffer\Files\File;


/**
 * This sniff prohibits the use of console.log().
 *
 * 
 * @category  PHP
 * @package   PHP_CodeSniffer
 */
class SinguStandard_Sniffs_Js_ForbiddenJsConsoleSniff implements Sniff
{
    
    public $supportedTokenizers = array('JS');
    
    /**
     * Returns an array of tokens this test wants to listen for.
     *
     * @return array
     */
    public function register()
    {
        return array(T_OBJECT_OPERATOR);
    }//end register()
    
    /**
     * Processes this test, when one of its tokens is encountered.
     *
     * @param PHP_CodeSniffer_File $phpcsFile The file being scanned.
     * @param int                  $stackPtr  The position of the current token in the
     *                                        stack passed in $tokens.
     *
     * @return void
     */
    public function process(File $phpcsFile, $stackPtr)
    {
        
        $tokens = $phpcsFile->getTokens();
        
        if ($tokens[$stackPtr + -1]['content'] == "console" && $tokens[$stackPtr + 1]['content'] == "log") {
            $error = 'The use of function console.log() is forbidden';
            $phpcsFile->addError($error, $stackPtr, 'NotAllowed');
        }
    }//end process()
}//end class

?>
