<?php

namespace PHP_CodeSniffer\Standards\SinguStandard\Sniffs\Functions;

use PHP_CodeSniffer\Sniffs\Sniff;
use PHP_CodeSniffer\Files\File;

/**
 * This sniff prohibits the use of \Velis\Debug:;stop.
 *
 * 
 * @category  PHP
 * @package   PHP_CodeSniffer
 */
class SinguStandard_Sniffs_Functions_ForbiddenVelisSniff implements Sniff
{
    /**
     * Returns an array of tokens this test wants to listen for.
     *
     * @return array
     */
    public function register()
    {
        return array(T_DOUBLE_COLON);
    }//end register()
    
    /**
     * Processes this test, when one of its tokens is encountered.
     *
     * @param PHP_CodeSniffer_File $phpcsFile The file being scanned.
     * @param int                  $stackPtr  The position of the current token in the
     *                                        stack passed in $tokens.
     *
     * @return void
     */
    public function process(File $phpcsFile, $stackPtr)
    {

        
        $tokens = $phpcsFile->getTokens();
        
        if (strtolower($tokens[$stackPtr + -1]['content']) == "debug" && $tokens[$stackPtr + 1]['content'] == "stop") {
            $error = 'The use of function \Velis\Debug::stop() is forbidden';
            $phpcsFile->addError($error, $stackPtr, 'NotAllowed');
        }
    }//end process()
}//end class

?>
