<?php

namespace PHP_CodeSniffer\Standards\SinguStandard\Sniffs\Functions;

use PHP_CodeSniffer\Sniffs\AbstractVariableSniff;
use PHP_CodeSniffer\Files\File;

/**
 *
 * @category  PHP
 * @package   PHP_CodeSniffer
 */
class SinguStandard_Sniffs_Functions_ForbiddenVelisFunctionNameSniff extends AbstractVariableSniff
{

    /**
     * Tokens to ignore so that we can find a DOUBLE_COLON.
     *
     * @var array
     */
    private $forbbidenNames = array(
        'aaa|bbb|ccc|zzz|xyz',
        'dupa'
    );
    /**
     * Processes this test, when one of its tokens is encountered.
     *
     * @param PHP_CodeSniffer_File $phpcsFile The file being scanned.
     * @param int                  $stackPtr  The position of the current token in the
     *                                        stack passed in $tokens.
     *
     * @return void
     */
    protected function processVariable(File $phpcsFile, $stackPtr)
    {
        $tokens  = $phpcsFile->getTokens();
        $varName = ltrim($tokens[$stackPtr]['content'], '$');
        $phpReservedVars = array(
                            '_SERVER',
                            '_GET',
                            '_POST',
                            '_REQUEST',
                            '_SESSION',
                            '_ENV',
                            '_COOKIE',
                            '_FILES',
                            'GLOBALS',
                            'http_response_header',
                            'HTTP_RAW_POST_DATA',
                            'php_errormsg',
                           );



        // If it's a php reserved var, then its ok.
        if (in_array($varName, $phpReservedVars) === true) {
            return;
        }


        foreach ($this->forbbidenNames as $pattern) {
            if (preg_match('/'.$pattern.'/',$tokens[$stackPtr]['content'])) {
                    $error = 'The name of function '. $tokens[$stackPtr]['content'] .' is forbidden';
                    $phpcsFile->addError($error, $stackPtr, 'NotAllowed');
            }
        }

    }//end processVariable()

    protected function processMemberVar(File $phpcsFile, $stackPtr)
    {
        return;
    }

    protected function processVariableInString(File $phpcsFile, $stackPtr)
    {
            $tokens  = $phpcsFile->getTokens();
            $varName = ltrim($tokens[$stackPtr]['content'], '$');
            $phpReservedVars = array(
                                '_SERVER',
                                '_GET',
                                '_POST',
                                '_REQUEST',
                                '_SESSION',
                                '_ENV',
                                '_COOKIE',
                                '_FILES',
                                'GLOBALS',
                                'http_response_header',
                                'HTTP_RAW_POST_DATA',
                                'php_errormsg',
                               );
            // If it's a php reserved var, then its ok.
            if (in_array($varName, $phpReservedVars) === true) {
                return;
            }


            foreach ($this->forbbidenNames as $pattern) {
                if (preg_match('/'.$pattern.'/',$tokens[$stackPtr]['content'])) {
                        $error = 'The use of word '. $tokens[$stackPtr]['content'] .' is forbidden';
                        $phpcsFile->addError($error, $stackPtr, 'NotAllowed');
                }
            }

    }
}//end class

?>
