<?php

namespace Velis\Filter;

use InvalidArgumentException;
use Velis\App;
use Velis\App\PhalconVersion;

class ValidatorFactory
{
    /**
     * @param string $type
     * @param array $options
     * @return \Phalcon\Filter\Validation\ValidatorInterface|\Phalcon\Validation\ValidatorInterface
     */
    public function createValidator(string $type, array $options)
    {
        if (App::getPhalconMajorVersion() >= PhalconVersion::PHALCON5) {
            $namespace = '\Phalcon\Filter\Validation\Validator';
        } else {
            $namespace = '\Phalcon\Validation\Validator';
        }

        $validatorClass = sprintf('%s\%s', $namespace, $type);
        if (!class_exists($validatorClass)) {
            throw new InvalidArgumentException(sprintf('Cannot instantiate %s validator, class %s does not exist', $type, $validatorClass));
        }

        return new $validatorClass($options);
    }
}
