<?php

namespace Velis\Filter;

use Laminas\Filter\FilterInterface;
use Velis\Output;

/**
 * Acronym filter
 * @author Olek Procki <olo@velis.pl>
 */
class Acronym implements FilterInterface
{
    /**
     * Returns acronym suitable to use in URL
     *
     * @param string $text
     * @return string
     */
    public function filter($text)
    {
        $str = Output::stripPolishChars($text);

        $str = str_replace([' ', '_'], '-', $str);
        $str = preg_replace('/\-+/', '-', $str);
        $str = preg_replace('/[^a-z0-9\-]/i', '', $str);
        $str = trim($str);

        if (strlen($str) == 0) {
            $str = 'unknown';
        }
        return strtolower($str);
    }


    /**
     * Invoke magic method
     *
     * @param string $text
     * @return string
     */
    public function __invoke($text)
    {
        return $this->filter($text);
    }
}
