<?php

namespace Velis\Filesystem\Av\Concrete;

use Socket;
use Velis\Filesystem\Av\Contract\SocketInterface;

/**
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
class SocketWrapper implements SocketInterface
{
    public function __construct(
        private readonly Socket $socket,
    ) {
    }

    public static function fromSocket(Socket $socket): self
    {
        return new self($socket);
    }

    public function send(string $data, int $length, int $flags): int
    {
        return socket_send($this->socket, $data, $length, $flags);
    }

    public function recv(&$buffer, int $length, int $flags): int
    {
        return socket_recv($this->socket, $buffer, $length, $flags);
    }

    public function close(): void
    {
        socket_close($this->socket);
    }

    public function socketExportStream(): mixed
    {
        return socket_export_stream($this->socket);
    }
}
