<?php

namespace Velis\Filesystem\Adapter;

use Gaufrette\FilesystemInterface as GaufretteFilesystemInterface;
use Velis\Filesystem\CopyTrait;
use Velis\Filesystem\ImageSizeTrait;
use Velis\Filesystem\ListKeysTrait;
use Velis\Filesystem\SymlinkTrait;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class Local extends GaufretteFilesystemWrapper
{
    use CopyTrait;
    use ImageSizeTrait;
    use ListKeysTrait;
    use SymlinkTrait;


    /**
     * @var string
     */
    private $basePath;


    /**
     * @param GaufretteFilesystemInterface $filesystem
     * @param string                       $basePath
     */
    public function __construct(GaufretteFilesystemInterface $filesystem, $basePath)
    {
        parent::__construct($filesystem);

        $this->basePath = rtrim($basePath, '/') . '/';
    }

    /**
     * {@inheritDoc}
     */
    protected function rmdir($key)
    {
        return rmdir($this->basePath . $key);
    }


    /**
     * {@inheritDoc}
     */
    public function listKeys($prefix = '')
    {
        return $this->listKeysInDirectory('', $prefix);
    }
}
