<?php

namespace Velis\Exception;

use Throwable;
use Velis\Api\HttpExceptionHandler\HttpException;
use Velis\Lang;

class UnauthorizedException extends HttpException
{
    public function __construct(
        $message = null,
        $code = 0,
        ?string $error = null,
        ?array $details = null,
        ?int $httpCode = null,
        Throwable $previous = null
    ) {
        $message ??= Lang::get('USER_UNAUTHORIZED');
        $httpCode ??= 401;

        parent::__construct($message, $code, $error, $details, $httpCode, $previous);
    }
}
