<?php

namespace Velis\Exception;

use Phalcon\Http\Message\ResponseStatusCodeInterface;
use Throwable;
use Velis\Api\HttpExceptionHandler\HttpException;
use Velis\Api\HttpExceptionHandler\HttpExceptionInterface;

/**
 * Base class for operation logic exceptions.
 * As operation logic exception, we understand situations when data from the user cannot be processed
 * because of the business logic: e.g., trying to update closed inspection or change the building of the meter.
 * The situations when exceptions with http code 401 / 403 or just 500 are not suitable.
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
class BusinessLogicException extends HttpException implements HttpExceptionInterface
{
    public function __construct(
        $message = null,
        $code = 0,
        ?string $error = null,
        ?array $details = null,
        ?int $httpCode = null,
        Throwable $previous = null
    ) {
        $message ??= 'Unprocessable content.';
        $httpCode ??= ResponseStatusCodeInterface::STATUS_UNPROCESSABLE_ENTITY;

        parent::__construct($message, $code, $error, $details, $httpCode, $previous);
    }
}
