<?php

namespace Velis\Dto\Validators;

use Attribute;

#[Attribute]
class OneOf extends BaseValidator
{
    public function __construct(
        public array $allowedValues,
        public string $message = 'Invalid value'
    ) {
    }

    public function validate($value): bool
    {
        return in_array($value, $this->allowedValues);
    }
}
