<?php

namespace Velis\Dto\Validators;

use Attribute;

/**
 * Int size checking validator.
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
#[Attribute]
class IntRange extends BaseValidator
{
    public function __construct(
        public ?int $min = null,
        public ?int $max = null,
        public string $message = 'Invalid int size'
    ) {
    }

    public function validate($value): bool
    {
        if (!is_int($value)) {
            return false;
        }

        if ($this->min !== null && $value < $this->min) {
            return false;
        }

        if ($this->max !== null && $value > $this->max) {
            return false;
        }

        return true;
    }
}
