<?php

namespace Velis\Dto\Validators;

use Attribute;
use Velis\Dto\Validators\BaseValidator;
use Velis\Filter;

#[Attribute]
class HexColor extends BaseValidator
{
    public function __construct(
        public string $message = 'Invalid color format'
    ) {
    }

    /**
     * @param mixed $value
     */
    // phpcs:ignore SlevomatCodingStandard.TypeHints.ParameterTypeHint.MissingNativeTypeHint
    public function validate($value): bool
    {
        if (Filter::filterCssColor($value) !== $value) {
            return false;
        }

        return true;
    }
}
