<?php

namespace Velis\Dto\Validators;

/**
 * Base Validator Attribute class.
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
abstract class BaseValidator implements Validatable
{
    /**
     * Base message for each validator, when value is invalid.
     */
    public string $message = 'Invalid value';

    /**
     * All input data passed to the DTO's constructor
     * @var array
     */
    protected readonly array $dtoData;

    abstract public function validate($value): bool;

    public function getMessage(): string
    {
        return $this->message;
    }

    public function setDtoData(array $dtoData): void
    {
        $this->dtoData = $dtoData;
    }
}
