<?php

namespace Velis\Dto\Exceptions;

use Velis\Exception;

class ValidationException extends Exception
{
    public function __construct(
        ?string $message = null,
        private array $errors = [],
        int $code = 0,
        $previous = null,
        $debugInfo = null
    ) {
        $message ??= 'Validation failed.';

        parent::__construct($message, $code, $previous, $debugInfo);
    }

    public function getErrors(): array
    {
        return $this->errors;
    }
}
